function draw

% draw figures
global ngj delay_jj  imax g1m_store period_store amp_store j1max tspan;
global aiiA_store AHL_store AHLe_store luxI_store dB;
global dr g1m;
global AD1;

xstr = '                                          time';
if dr == 2
    fstr = [];
for i = 1:imax
    fstr = strcat(fstr, sprintf('''Fluid flow speed=%3.3f''', g1m(i)), sprintf(',  \b'));
end
fstr(end-3:end) = [];
%density, (speed)
for jj = 1:j1max
    figure;%set(gcf,'windowstyle','modal');
    set(gcf,'Position',[200 100 600 600]);
    for i = 1:imax
        subplot(4,1,1); plot(tspan, aiiA_store(i, :, jj), '-','Color',[i/imax*250/255 i/imax*250/255 i/imax*20/255]);ylabel('aiiA');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,2); plot(tspan, AHL_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('AHL internal');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,3); plot(tspan, AHLe_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('AHL external');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,4); plot(tspan, luxI_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*250/255 i/imax*250/255 i/imax*25.5/255]);ylabel('luxI');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
%         legend(sprintf('''Fluid flow speed=%3.3f''', g1m(i)));
    end
    ffstr=strcat('legend(', fstr, ')');
    ffstr=strrep(ffstr, char(8), char(32));
    eval(ffstr);
end

elseif dr == 1
    dstr = [];
for jj = 1:j1max;
    dstr = strcat(dstr, sprintf('''Cell density=%3.3f''', ngj(jj)), sprintf(',  \b'));
end
dstr(end-3:end) = [];
%speed, (density)
for i =1:imax
    figure;
    set(gcf,'Position',[200 100 600 600]);
    for jj = 1:j1max
        subplot(4,1,1); plot(tspan, aiiA_store(i, :, jj), '-','Color',[jj/j1max*250/255 jj/j1max*20/255 jj/j1max*50/255]);ylabel('aiiA');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,2); plot(tspan, AHL_store(i, :, jj), '-','MarkerSize',5,'Color',[jj/j1max*250/255 jj/j1max*20/255 jj/j1max*50/255]);ylabel('AHL internal');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,3); plot(tspan, AHLe_store(i, :, jj), '-','MarkerSize',5,'Color',[jj/j1max*250/255 jj/j1max*20/255 jj/j1max*50/255]);ylabel('AHL external');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
        subplot(4,1,4); plot(tspan, luxI_store(i, :, jj), '-','MarkerSize',5,'Color',[jj/j1max*250/255 jj/j1max*20/255 jj/j1max*50/255]);ylabel('luxI');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i))); hold on;
%         legend(sprintf('''Cell density=%3.3f''', ngj(jj)));
    end
    ddstr=strcat('legend(', dstr, ')');
    ddstr=strrep(ddstr, char(8), char(32));
    eval(ddstr);
end

elseif dr == 3
%saparete
for jj = 1:j1max
    for i = 1:imax
        figure;
        set(gcf,'Position',[200 100 600 600]);
        subplot(4,1,1); plot(tspan, aiiA_store(i, :, jj), '-','Color',[i/imax*20/255 i/imax*200/255 i/imax*50/255]);ylabel('aiiA');xlabel(xstr);  title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i)));
        subplot(4,1,2); plot(tspan, AHL_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*20/255 i/imax*200/255 i/imax*50/255]);ylabel('AHL internal');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i)));
        subplot(4,1,3); plot(tspan, AHLe_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*20/255 i/imax*200/255 i/imax*50/255]);ylabel('AHL external');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i)));
        subplot(4,1,4); plot(tspan, luxI_store(i, :, jj), '-','MarkerSize',5,'Color',[i/imax*20/255 i/imax*200/255 i/imax*50/255]);ylabel('luxI');xlabel(xstr); title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i)));
    end
end
end




dB = str2double(get(AD1.E13, 'string'));
figure;
set(gcf, 'Position', [50 50 1000 600]);
if ~get(AD1.C1, 'value')
    dc = 1;
    for jj = 1:j1max
        for i = 1:imax
            subplot(4,4,dc);
            dc = dc+1;
            plot(tspan+delay_jj, luxI_store(i, :, jj), '-', 'Color', [0 0 1]);ylabel('Fluorescence a.u.');xlabel(xstr);title(sprintf('Cell density=%3.3f \nFluid flow speed=%3.3f', ngj(jj),g1m(i)));
            if dc == 17 && ~(jj == j1max && i == imax)
                figure;
                set(gcf, 'Position', [50 50 1000 600]);
                dc = 1;
            end
        end
    end
else
    dc = 1;
    Fluo=ones(size(luxI_store));%Fluorescence
    for jj = 1:j1max
        Fluo(:, :, jj) = awgn(luxI_store(:, :, jj), dB);
    end
    for jj = 1:j1max
        for i = 1:imax
            subplot(4,4,dc);
            dc = dc+1;
                plot(tspan+delay_jj, Fluo(i, :, jj), '-', 'Color', [0 0 1]);ylabel('Fluorescence a.u.');xlabel(xstr);title(sprintf('Cell density=%3.3f, Fluid flow speed=%3.3f\nWhite noise %3.2fdB', ngj(jj),g1m(i),dB));
            if dc == 17 && ~(jj == j1max && i == imax)
                figure;
                set(gcf, 'Position', [50 50 1000 600]);
                dc = 1;
            end
        end
    end
    figure;
    set(gcf, 'Position', [200 200 500 400]);
    plot(tspan+delay_jj, Fluo(1, :, 1)-luxI_store(1,:,1), '-', 'Color', [0 0 1]);ylabel('White noise a.u.');xlabel(xstr);title(sprintf('White noise %3.2fdB', dB));
end



if (~get(AD1.C2, 'value'))
    gstr = '                                                                                  fluid flow speed';
    for jj = 1:j1max
        figure;
        set(gcf,'Position', [200 100 600 600]);
        subplot(2,1,1); plot(g1m_store(jj,:),period_store(jj,:),'x-','Color',[jj/j1max*20/255 jj/j1max*250/255 jj/j1max*20/255]);ylabel('period');xlabel(gstr);
        title(sprintf('Cell density=%3.3f', ngj(jj)));
        subplot(2,1,2); plot(g1m_store(jj,:),amp_store(jj,:),'x-','Color',[jj/j1max*20/255 jj/j1max*250/255 jj/j1max*20/255]);ylabel('amplitude');xlabel(gstr);
        title(sprintf('Cell density=%3.3f', ngj(jj)));
    end
end
if (~get(AD1.C3, 'value'))
    gstr = '                                                                                          cell density';
    figure;
    set(gcf, 'Position', [200 100 600 600]);
    subplot(2,1,1); plot(ngj(1, 1:jj),period_store(1:jj, 1),'x-','Color',[jj/j1max*20/255 jj/j1max*250/255 jj/j1max*20/255]);ylabel('period');xlabel(gstr);
    title(sprintf('Fluid flow speed=%3.3f', g1m(1)));
    subplot(2,1,2); plot(ngj(1, 1:jj),amp_store(1:jj, 1),'x-','Color',[jj/j1max*20/255 jj/j1max*250/255 jj/j1max*20/255]);ylabel('amplitude');xlabel(gstr);
    title(sprintf('Fluid flow speed=%3.3f', g1m(1)));
end

clear Sint imax g1m_store period_store amp_store;
clear aiiA_store AHL_store AHLe_store luxI_store;
clear dr fg ng;
end